%% Cu-ZSM-5 dehydrated simulations
clear, clc
[x,y] = eprload('Cu_ZSM-5_dehyd_77K.DSC');
corrspc = basecorr(y,1,0);
Sys0.g = [2.073 2.268];
Sys0.lwpp = [0 3.3];
Sys0.Nucs = 'Cu';
Sys0.A = [40 570];
Sys1.g = [2.068 2.314];
Sys1.lwpp = [0 3.3];
Sys1.Nucs = 'Cu';
Sys1.A = [40 530];
Sys0.weight = 0.55;
Sys1.weight = 0.45;
Exp.Range = [229.98 429.97]; %in mT
Exp.mwFreq = 9.431822;
Exp.ModAmp = 0.5; %in mT
Exp.nPoints = 4000;
Exp.Temperature = 70;
[xb,yb] = pepper({Sys0,Sys1},Exp);
B = x/10;
corrspc = corrspc/max(corrspc);
sim = yb/max(yb);
plot(B,corrspc,xb,sim);
%% Na-Cu-ZSM-5 dehydrated simulations
clear, clc
[x,y] = eprload('Na_Cu_ZSM-5_dehyd_77K.DSC.DSC');
corrspc = basecorr(y,1,0);
Sys0.g = [2.073 2.260];
Sys0.lwpp = [0 3.3];
Sys0.Nucs = 'Cu';
Sys0.A = [40 549];
Sys1.g = [2.063 2.303];
Sys1.lwpp = [0 3.3];
Sys1.Nucs = 'Cu';
Sys1.A = [40 510];
Sys0.weight = 0.5;
Sys1.weight = 0.5;
Exp.Range = [229.98 429.97]; %in mT
Exp.mwFreq = 9.431822;
Exp.ModAmp = 0.5; %in mT
Exp.nPoints = 4000;
Exp.Temperature = 70;
[xb,yb] = pepper({Sys0,Sys1},Exp);
B = x/10;
corrspc = corrspc/max(corrspc);
sim = yb/max(yb);
plot(B,corrspc,xb,sim);
%% TPAOH-Cu-ZSM-5 dehydrated simulations
clear, clc
[x,y] = eprload('TPAOH_Cu_ZSM-5_dehyd_77K.DSC');
corrspc = basecorr(y,1,0);
Sys0.g = [2.073 2.270];
Sys0.lwpp = [0 3.3];
Sys0.Nucs = 'Cu';
Sys0.A = [40 549];
Sys1.g = [2.068 2.318];
Sys1.lwpp = [0 3.3];
Sys1.Nucs = 'Cu';
Sys1.A = [40 520];
Sys0.weight = 0.5;
Sys1.weight = 0.5;
Exp.Range = [229.98 429.97]; %in mT
Exp.mwFreq = 9.4323;
Exp.ModAmp = 0.5; %in mT
Exp.nPoints = 4000;
Exp.Temperature = 70;
[xb,yb] = pepper({Sys0,Sys1},Exp);
B = x/10;
corrspc = corrspc/max(corrspc);
sim = yb/max(yb);
plot(B,corrspc,xb,sim);
